from GamePlay import PYBaseGamePlay
import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

#For some odd reason, you only live twice...
class TurboYOLT(PYBaseGamePlay):
	def __init__(self):
		super(TurboYOLT, self).__init__()
		self.waitingForPlayers = False
		self.radarSet = False

	def GetPrintName(self):
		return "TurboYOLT"
		
	def GetHelpString(self):
		return "#GES_GP_YOLT_HELP"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team TurboYOLT"
		else:
			return "TurboYOLT"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
		self.LoadConfig()
		self.CreateCVar("ge_velocity", "1.5", "Velocity (speed) multiplier, range from 0.5 to 1.5.")
	
	def OnPlayerConnect(self, player):
		if GEMPGameRules.IsRoundLocked():
			player.SetDeaths(2);
	
	def OnRoundBegin(self):
		self.radarSet = False;
		GEMPGameRules.GetRadar().SetForceRadar( False );

		GEMPGameRules.UnlockRound();
		GEMPGameRules.ResetAllPlayerDeaths();
		GEMPGameRules.ResetAllPlayersScores();
		
	def OnRoundEnd(self):
		GEMPGameRules.GetRadar().DropAllContacts();
		
	def OnPlayerSpawn(self, player):
		player.SetSpeedMultiplier( float(GEUtil.GetCVarValue("ge_velocity")) )
		
	def OnPlayerKilled(self, victim, killer, weapon):
		#what exactly got killed?
		if not victim:
			return
		
		if not self.waitingForPlayers and victim.GetDeaths() >= 2:
			GEMPGameRules.LockRound();
			GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "#GES_GP_YOLT_ELIMINATED", victim.GetPlayerName() );	
					
		#death by world
		if not killer:
			victim.IncrementScore( -1 )
			return
		
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
		else:
			team = GEMPGameRules.GetTeam(killer.GetTeamNumber())
			team.IncrementRoundScore( 1 )
			killer.IncrementScore( 1 )
		
	def OnThink(self):
		if GEMPGameRules.GetNumActivePlayers() < 2:
			GEMPGameRules.UnlockRound()
			self.waitingForPlayers = True
			return

		if self.waitingForPlayers:
			self.waitingForPlayers = False
			GEMPGameRules.EndRound( False )
		
		#Check to see if the round is over!
		if GEMPGameRules.IsTeamplay():
			#check to see if each team has a player...
			iMI6PlayersLeft = 0
			iJanusPlayersLeft = 0
			
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
		
				player = GEUtil.GetMPPlayer(i)
			
				if player.GetDeaths() < 2 and player.GetTeamNumber() is not GEGlobal.TEAM_SPECTATOR:
				
					if player.GetTeamNumber() == GEGlobal.TEAM_MI6:
						iMI6PlayersLeft += 1
					elif player.GetTeamNumber() == GEGlobal.TEAM_JANUS:
						iJanusPlayersLeft += 1

			if iMI6PlayersLeft == 0 and iJanusPlayersLeft == 0:
				GEMPGameRules.EndRound()
				
			elif iMI6PlayersLeft == 0 and iJanusPlayersLeft > 0:
				janus = GEMPGameRules.GetTeam( GEGlobal.TEAM_JANUS )
				janus.IncrementMatchScore(5)
				GEMPGameRules.SetTeamWinner( janus )
				GEMPGameRules.EndRound()
				
			elif iJanusPlayersLeft == 0 and iMI6PlayersLeft > 0:
				mi6 = GEMPGameRules.GetTeam( GEGlobal.TEAM_MI6 )
				mi6.IncrementMatchScore(5)
				GEMPGameRules.SetTeamWinner( mi6 );
				GEMPGameRules.EndRound();
		else:
			#Check to see if more than one player is around
			iPlayers = [];

			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
		
				player = GEUtil.GetMPPlayer(i)
				
				if player.GetDeaths() < 2 and player.GetTeamNumber() is not GEGlobal.TEAM_SPECTATOR:
					iPlayers.append(player)

			if len(iPlayers) == 0:
				#This shouldn't happen, but just in case it does we don't want to overflow the vector...
				GEMPGameRules.EndRound();
			if len(iPlayers) == 1:
				GEMPGameRules.SetPlayerWinner( iPlayers[0] );
				GEMPGameRules.EndRound();
			elif len(iPlayers) == 2 and not self.radarSet:	
				#Add the two players as always visible on the radar
				radar = GEMPGameRules.GetRadar()
				radar.SetForceRadar( True );
				radar.AddRadarContact( iPlayers[0], GEGlobal.RADAR_TYPE_PLAYER, True );
				radar.AddRadarContact( iPlayers[1], GEGlobal.RADAR_TYPE_PLAYER, True );
				self.radarSet = True;

	def CanPlayerRespawn(self, player):
		if player.GetDeaths() >= 2 and GEMPGameRules.IsRoundLocked():
			return False;

		return True;

	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == "ge_velocity":
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				player.SetSpeedMultiplier( float(newvalue) )